#include<stdio.h>

//Passage dans une fonction : évaluation des expressions en argument
//Recopie dans un environnement locale à la fonction

//Donc dans cette fonction on a perdu le lien avec les a et b du main
void swap_val(int a, int b) {
  int c = a;
  a = b;
  b = c;
  printf("SWAP VAL a=%d, b=%d\n", a, b);
}

//Ici on manipule les adresses de variables entières déclarées dans le main
//Les modifications en passant par les pointeurs seront donc directement effectuées
//sur les variables visibles dans le main
void swap_var(int* a_ptr, int* b_ptr) { //int* ptr. La variable ptr, est un pointeur vers un int
  int c = *a_ptr;  //*ptr = on accède à la valeur de la case à l'adresse contenue dans a_ptr
  *a_ptr = *b_ptr;
  *b_ptr = c;
  printf("SWAP VAR a=%d, b=%d\n", *a_ptr, *b_ptr);
}

int main() {

  int a = 3;
  int b = 5;

  //On donne les valeurs directement
  swap_val(a, b);
  printf("MAIN : a=%d, b=%d\n", a, b);

  //Ici on donne les adresses, qui seront aussi recopiées mais on pourra remonter vers a et b
  swap_var(&a, &b);
  printf("MAIN : a=%d, b=%d\n", a, b);

  return 0;
}
