# TP 1 TS326

import numpy as np
import matplotlib.pyplot as plt
from utils import score_classif

# Hierarchical Ascendant Classification %%%

plt.close('all')

data = np.load('./data/cloud_data_1.npy')
N = data.shape[0]
classif_true = data[:,2].astype('int')-1
K = np.unique(classif_true).shape[0]
X = data[:,0:2].T

colors = np.array([[1, 0, 0],[0, 1, 0], [0, 0, 1], [0, 0, 0], [1, 1, 0], [1, 0, 1], [0, 1, 1]])

plt.figure(1)
plt.subplot(121)
for j in range(0,N):
    plt.plot(X[1,j], X[0,j], marker='*', color=colors[classif_true[j],:])

plt.subplot(122)
for j in range(0,N):
    color_rand = list(np.random.rand(3,))
    plt.plot(data[j,1], data[j,0], marker='*', color=color_rand)

clustering_type = 'avg' #'min', 'max', 'bary', 'ward'

classif_exp = np.zeros((N,N)).astype('int') #stroage matrix for classification
classif_exp[0,:] = range(0,N) #each sample is a class
Gi = np.copy(X)


for i in range(1,N-K+1): # 2:N-K+1

    #Start from previous classification
    classif_exp[i,:] = classif_exp[i-1,:]
    
    ##### TO MODIFY #####
    
    #Get all living clusters at current iteration (np.unique)
    elements = np.unique(classif_exp[i,:])
    
    #Search for the lowest distance between all classes and keep the two corresponding labels
    old_ = 0
    new_ = 0
    min_d = 99999999999
    for i in range(0, elements.shape[0]):
        l_i = elements[i]
        #...
            #Compute the distance between barycenters
            #If lower distance than current lowest one, get the two corresponding labels
            #...
            
            
    #Merge: Replace one the two labels with the other one (keep lowest one by convention)
    #Only classif_exp[i,:] must be updated
    #...
   
    #Recompute the new barycenter G[:,new_label]
    #Only need to recompute the barycenter of the surviving label since the other disappeared from classif_exp[i,:]
    #...
    
    ###########
    
    #plot res
    color_rand = list(np.random.rand(3,))
    plt.plot(X[1,classif_exp[i,:] == new_], X[0,classif_exp[i,:] == new_], color=color_rand)
    plt.title('Classes : {}'.format(N-(i-1)))
    plt.show()
    plt.pause(0.001)


#%%
#Compute score
score = score_classif(K, classif_exp[N-K,:], classif_true)
plt.title('Iteration {} - score {}'.format(N-K+1, score))


