# TP 1 TS326

import numpy as np
import matplotlib.pyplot as plt
from utils import compute_inertia, score_classif

plt.close('all')

data = np.load('./data/cloud_data_1.npy')
N = data.shape[0]
classif_true = data[:,2].astype('int')-1
K = np.unique(classif_true).shape[0]
p = 2
X = data[:,0:p].T

colors = np.array([[1, 0, 0],[0, 1, 0], [0, 0, 1], [0, 0, 0], [1, 1, 0], [1, 0, 1], [0, 1, 1]])

plt.figure(1)
plt.subplot(121)
for j in range(0,N):
    plt.plot(data[j,1], data[j,0], marker='*', color=colors[classif_true[j],:])


#% INITIALISATION %%%

iter = 5

#% Init seeds Gi = zi
Gi = np.zeros((p,K))
#INIT RANDOM GI (à compléter)


#%%
#% K means loop
score = np.zeros((iter,1))
classif_exp = np.ones((N,1)).astype('int') #Vecteur de classif

for i in range(0, iter):
    
    print(i)

    #Distance between all points X and all cluster barycenters Gi (np.sum)
    
    #Association of each point to the closest barycenter (np.argmin)

    #Update of all class barycenters (np.mean)

    #Score classif
    score[i] = score_classif(K, classif_exp.astype(float), classif_true)

    #plot res
    plt.figure(1)
    plt.subplot(122)
    for j in range(0,N):
        plt.plot(X[1,j], X[0,j], color=colors[classif_exp[j].astype(int),:], marker='*')
    for k in range(0,K):
        plt.plot(Gi[1,k], Gi[0,k], marker='+', color=colors[k,:], markersize=10+i*5) # 'MarkerSize', 10)
    plt.title('Iteration {} - score {}'.format(i, score[i]))
    plt.show()
    plt.pause(1)

