import numpy as np
import itertools #to compute the score


def compute_inertia(K, seeds, data, classif_exp):

    #Variations
    G = np.mean(seeds, axis=1)
    N = data.shape[0]
    
    #Inter classes
    ni = np.zeros((K,1))
    I_inter = 0
    for j in range(0,K):
        ni = np.sum(classif_exp == j)
        I_inter = I_inter + ni*np.sum((seeds[:,j]-G)**2)
    I_inter = I_inter/N
    
    #Intra classes
    I_intra = 0
    for j in range(0,N):
        I_intra = I_intra + np.sum((seeds[:,classif_exp[j]]-data[j,0:2])**2)
    I_intra = I_intra/N
    
    #Totale
    I_tot = 0
    for j in range(0,N):
        I_tot = I_tot + np.sum((G-data[j,0:2])**2)
    I_tot = I_tot/N
    
    return I_inter, I_intra, I_tot



def score_classif(K, classif_exp, classif_real):

    classif_tmp = np.copy(classif_exp)
    #reset between 0 and K-1
    c = 0
    for i in np.unique(classif_tmp):
        classif_tmp[classif_tmp == i] = c
        c = c + 1
        
    #list of possible permutations
    permut = itertools.permutations(range(0,K))
    permut_array = np.empty((0,K))
    for p in permut:
        permut_array = np.append(permut_array, np.atleast_2d(p), axis=0)
    
    score_max = 0
   
    for j in range(0, permut_array.shape[0]):
        classif_j = np.copy(classif_tmp)
        for p in range(0,K):
            classif_j[classif_tmp == p] = permut_array[j,p]
        
        score = np.mean((classif_j == classif_real))
        if (score > score_max):
            score_max = score
        
    
    return score_max


def compute_ASA(data, cluster):
    sum_inter = 0
    max_cluster = max(cluster)
    min_cluster = min(cluster)

    for clust in range(min_cluster, max_cluster+1):
        indexes = np.nonzero(clust == cluster)

        sem_clust = data[indexes]
        set_sem_clust = set(sem_clust)
        intersection = []
        for i in set_sem_clust:
            intersection.append(np.sum(sem_clust == i))
        if (len(intersection)>0):
            sum_inter += np.max(intersection)

    return sum_inter/len(cluster)