import matplotlib.pyplot as plt
import numpy as np 
import skimage

img = plt.imread('../img/pool.tif')

#With skimage
img_ycbcr = skimage.color.rgb2ycbcr(img)
Y = img_ycbcr[:,:,0]
Cb = img_ycbcr[:,:,1]
Cr = img_ycbcr[:,:,2]

##### Without skimage ######
R = img[:,:,0].astype('double')
G = img[:,:,1].astype('double')
B = img[:,:,2].astype('double')

M = [[0.299, 0.587, 0.114],
     [-0.564*0.299, -0.564*0.587, 0.564*(1-0.114)],
     [0.713*(1-0.299), -0.713*0.587, -0.713*0.114]]
M_inv = np.linalg.inv(M) #Transformée inverse

img_ycbcr_manual = img@M  
img_rgb = img_ycbcr_manual@M_inv
#############################

plt.figure(1)
plt.subplot(221)
plt.imshow(img); plt.title('Image')
plt.subplot(222)
plt.imshow(Y, cmap='gray'); plt.title('Y')
plt.subplot(223)
plt.imshow(Cb, cmap='gray'); plt.title('Cb')
plt.subplot(224)
plt.imshow(Cr, cmap='gray'); plt.title('Cr')




#Resize de Cb, Cr
r = 0.1
Cb_r = skimage.transform.resize(Cb, (Cb.shape[0]*r, Cb.shape[1]*r))
Cr_r = skimage.transform.resize(Cr, (Cr.shape[0]*r, Cr.shape[1]*r))

#Réagrandissement de Cb, Cr
Cb_r2 = skimage.transform.resize(Cb_r, (Cb.shape[0], Cb.shape[1]))
Cr_r2 = skimage.transform.resize(Cr_r, (Cr.shape[0], Cr.shape[1]))
Cr_r2_nearest = skimage.transform.resize(Cr_r, (Cr.shape[0], Cr.shape[1]), order=0)

plt.figure(2)
plt.subplot(221)
plt.imshow(Cr); plt.title('Cr')
plt.subplot(222)    
plt.imshow(Cr_r); plt.title('Cr downsize')
plt.subplot(223)    
plt.imshow(Cr_r2); plt.title('Cr upsized (interpolated)')
plt.subplot(224)    
plt.imshow(Cr_r2_nearest); plt.title('Cr upsized (without interpolation - nearest)')

#Reconstitution de l'image YCBCR
img_ycbcr[:,:,1] = Cb_r2
img_ycbcr[:,:,2] = Cr_r2

#Passage en RGB
img_comp = skimage.color.ycbcr2rgb(img_ycbcr)

plt.figure(3)
plt.subplot(121)
plt.imshow(img); plt.title('initial image')
plt.subplot(122)
plt.imshow(img_comp); plt.title('compressed image')