import numpy as np
import matplotlib.pyplot as plt

def p1_disks(size, radius, dist):
    
    x_v = range(0, size)
    y_v = range(0, size)
    X, Y = np.meshgrid(x_v, y_v)
    
    
    cb = (size/2+dist, size/2);
    cg = (size/2 - dist*np.sin(np.pi/6), size/2 - dist*np.cos(np.pi/6));
    cr = (size/2 - dist*np.sin(np.pi/6), size/2 + dist*np.cos(np.pi/6));
    
    B = ((X-cb[1])**2 + (Y-cb[0])**2 <= radius**2)#.astype(int)*255
    R = ((X-cr[1])**2 + (Y-cr[0])**2 <= radius**2)#.astype(int)*255
    G = ((X-cg[1])**2 + (Y-cg[0])**2 <= radius**2)#.astype(int)*255
    
    return R, G, B


size = 255
radius = 70
dist = 45

R, G, B = p1_disks(size, radius, dist)

plt.figure(2)
plt.subplot(131)
plt.imshow(R)
plt.colorbar()
plt.subplot(132)
plt.imshow(G)
plt.subplot(133)
plt.imshow(B)
plt.show()


#%%

circle = np.stack((R, G, B), axis=2)

plt.figure(1)
plt.imshow(circle.astype('int')*255)
plt.show()

