import numpy as np
import matplotlib.pyplot as plt

#%%
I = np.load('../img/challengeA.npy')

plt.figure(1)
plt.imshow(I) #Fail car en dehors du cube RGB [0,1] pour du float
plt.show()

plt.figure(2)
plt.imshow(I.astype('uint8'))
plt.imshow(np.uint8(I))
plt.show()



# RGB uint8 veut du [0,255], RGB double veut du [0,1]
# donc soit on repasse en uint8, soit on normalise pour être entre [0,1] 
plt.figure(3)
plt.imshow(I/255)
plt.show()


#%% %%%%%%%%%%% Intervalles d'intensité %%%%%%%%%%%%%%%%%
I = np.load('../img/challengeB.npy') #Radio


plt.figure(2)
plt.imshow(I, cmap='gray')
plt.colorbar()

plt.figure(3)
plt.imshow(I, vmin=100, vmax=130, cmap='jet')
plt.colorbar()
plt.show()




#%% %%%%%%%%%%% Format numérique %%%%%%%%%%%%%%%%%
I = np.load('../img/challengeC.npy') #World map

plt.figure(4)
plt.imshow(I)

from matplotlib import cm
from matplotlib.colors import ListedColormap

map_jet = cm.jet(range(0,256,40))
map_jet[2,0:3] = [1,0,1]
print(map_jet)

new_map = [[0,0,0,1],[1,0,0,1],[1,0,1,1],[0,0,1,1],[1,1,1,1],[1,1,0,1],[0,1,1,1],[0,1,0,1]]
p = plt.imshow(I, cmap= ListedColormap(new_map))
plt.colorbar()







