import numpy as np
import matplotlib.pyplot as plt
from scipy import signal
import skimage #pour ycbcr

img = plt.imread('../img/home.jpg')
img_ycbcr = skimage.color.rgb2ycbcr(img)

plt.figure()
plt.imshow(img)
plt.show()

#%%

P = range(-10,11)
X, Y = np.meshgrid(P, P)

# 2) On retrouve l’expression des dérivées en x et y de g(x,y) pour leur fournir les cartes du meshgrid et obtenir deux filtres détecteurs de contours Gx Gy :
sig = 1
Gx = -X/(2*np.pi*sig**4)*np.exp(-(X**2+Y**2)/(2*sig**2))
Gy = -Y/(2*np.pi*sig**4)*np.exp(-(X**2+Y**2)/(2*sig**2))

plt.figure()
plt.imshow(Gx)
plt.show()

#%%

#% 3) Calculer la norme des deux réponses pour obtenir une détection de contours :
Ix = signal.convolve2d(img_ycbcr[:,:,0], Gx, 'same')
Iy = signal.convolve2d(img_ycbcr[:,:,0], Gy, 'same')

plt.subplot(221)
plt.imshow(Ix)
plt.title('Détection de contours en X')
plt.subplot(222)
plt.imshow(Iy)
plt.title('Détection de contours en Y')

#Norme et normalisation entre 0 et 1
delta_I = np.sqrt(Ix**2 + Iy**2)
delta_I = delta_I / np.max(delta_I)
plt.subplot(223)
plt.imshow(delta_I)
plt.title('Carte de contours (intensité entre 0 et 1)');

#Seuillage binaire
delta_I_th = delta_I>0.35
plt.subplot(224)
plt.imshow(delta_I_th)
plt.title('Carte de contours binaire')


#%% Application pencil sketch

#On récupère la carte de contours soft (entre 0 et 1)
C = delta_I

alpha = 36
beta = 16
img_ycbcr[:,:,0] = (255-alpha)*(1-C) + beta
img_esquisse = skimage.color.ycbcr2rgb(img_ycbcr)

plt.figure()
plt.imshow(delta_I_th)
plt.imshow(img_esquisse)
plt.title('Résultat pencil skecth (Carte soft Gaussienne)')


plt.figure()
plt.imshow(C)
plt.title('Carte de contours Gaussienne')

#%% Comparaison avec le résultat de edge

#On récupère la carte de contours soft (entre 0 et 1)
C = skimage.feature.canny(img_ycbcr[:,:,0]/255)
#plt.imshow(C)
#plt.title('Carte binaire de edge')

img_ycbcr[:,:,0] = (255-alpha)*(1-C) + beta
img_esquisse = skimage.color.ycbcr2rgb(img_ycbcr)

plt.figure()
plt.imshow(delta_I_th)
plt.imshow(img_esquisse)
plt.title('Résultat pencil skecth (Carte soft de edge)')
plt.show()