import numpy as np
import matplotlib.pyplot as plt
from scipy import signal

img = plt.imread('../img/barbara_awgn_noise.png');

plt.figure()
plt.imshow(img, cmap='gray')
plt.show()

#Filtre moyenneur rectangle uniforme
H = np.array([[1, 1, 1], [1, 1, 1], [1, 1, 1]]) / 9
H = np.ones([3, 3])/9; #équivalents
img_f = signal.convolve2d(img, H, 'same')

plt.figure() 
plt.subplot(121); plt.imshow(img, cmap='gray'); plt.title('Image initiale')
plt.subplot(122); plt.imshow(img_f, cmap='gray'); plt.title('Image filtrée (moyenneur)')
plt.show()
#Avec le moyenneur, on perd les textures

#%% Gaussien

def fspecial_gauss(sigma):
    x, y = np.meshgrid(range(int(-3*sigma),int(3*sigma)+1), range(int(-3*sigma),int(3*sigma)+1))
    g = np.exp(-((x**2 + y**2)/(2.0*sigma**2)))
    return g/g.sum()

H = fspecial_gauss(2); 
plt.figure()
plt.imshow(H)
plt.title('Filtre gaussien');

img_f = signal.convolve2d(img, H, 'same')

plt.figure()
plt.subplot(121); plt.imshow(img, cmap='gray'); plt.title('Image initiale');
plt.subplot(122); plt.imshow(img_f, cmap='gray'); plt.title('Image filtrée (Gaussien)');
plt.show()
#Avec le Gaussien, un peu mieux mais pas des miracles

#Les deux filtrages échouent sur un bruit poivre et sel ('cameraman_sp_noise.png');

#%% Filtrage médian

img = plt.imread('../img/cameraman_sp_noise.png')
plt.figure()
plt.subplot(121); plt.imshow(img, cmap='gray'); plt.title('Image initiale')

if img.ndim == 2:
    h, w, c = img.shape[0], img.shape[1], 1
else:
    h, w, c = img.shape
    
v = 1 #Demi taille du voisinage (2v+1)*(2v+1)

I_f = np.zeros([h,w])


#%%
for i in range(v, h-v):
    for j in range(v, w-v):
        window = img[i-v:i+v+1, j-v:j+v+1]
        I_f[i,j] = np.median(window)

plt.subplot(122)
plt.imshow(I_f, cmap='gray')
plt.title('Image filtrée (médian)')
plt.show()




