import numpy as np
import matplotlib.pyplot as plt
from scipy import signal
import skimage

def fspecial_gauss(size, sigma):
    x, y = np.mgrid[-size//2 + 1:size//2 + 1, -size//2 + 1:size//2 + 1]
    g = np.exp(-((x**2 + y**2)/(2.0*sigma**2)))
    return g/g.sum()

img = plt.imread('../img/barbara.bmp')
img = img[:,:,0]

#%%
plt.figure()
plt.imshow(img)
plt.show()
plt.title('image originale')

facteur = 3
im_sousech = img[1:-1:facteur, 1:-1:facteur]

plt.figure()
plt.imshow(im_sousech)
plt.show()
plt.title('im sous éch')


#%%

#Réduction de dimension - Sous-échantillonnage

Is = img[1:img.shape[0]:4, 1:img.shape[1]:4] 
plt.figure() 
plt.subplot(222) 
plt.imshow(Is)
plt.title('Sous-éch manuel')

Is_imresize = skimage.transform.resize(img, [img.shape[0]/4, img.shape[1]/4])
plt.figure() 
plt.subplot(223) 
plt.imshow(Is_imresize)
plt.title('imresize')

#%% Filtrage passe-base a priori

filter_ = fspecial_gauss(5, 10)
img_passe_bas = signal.convolve2d(img, filter_, mode='same') #On filtre l'image avant de sous-échantillonner (c'est ce que fait imresize)

"""
img = plt.imread('../img/face.png')
h, w = img.shape[0:2]
if img.ndim==3:
    c = img.shape[2]
else:
    c = 1

img_f_r = img[:]
for i in range(0, c): 
    img_f_r[:, :, i] = signal.convolve2d(img[:,:,i], filter_, mode='same') #On filtre l'image avant de sous-échantillonner (c'est ce que fait imresize)
    
plt.figure()
plt.imshow(img_f_r)
plt.show()
"""

#%%
plt.figure()
plt.imshow(img_passe_bas)
plt.show()
plt.title('Image filtrée par un filtre passe bas')

Is_imresize_maison = img_passe_bas[::4, ::4]
plt.figure()
plt.imshow(Is_imresize_maison)
plt.show()

#%% Transformées de Fourier

plt.figure()
plt.subplot(221); plt.imshow(np.log10(abs(np.fft.fftshift(np.fft.fft2(img))))); plt.title('Image initiale')
plt.subplot(222); plt.imshow(np.log10(abs(np.fft.fftshift(np.fft.fft2(Is))))); plt.title('Sous-éch manuel')
plt.subplot(223); plt.imshow(np.log10(abs(np.fft.fftshift(np.fft.fft2(Is_imresize))))); plt.title('imresize')
plt.subplot(224); plt.imshow(np.log10(abs(np.fft.fftshift(np.fft.fft2(Is_imresize_maison))))); plt.title('imresize maison')

plt.show()

